package gov.va.vamf.scheduling.direct.serializer

import com.fasterxml.jackson.databind.ObjectMapper
import gov.va.vamf.scheduling.direct.serializer.XSSProtectionSerializer
import spock.lang.Specification

class XssProtectionSerializerSpec extends Specification {
    private def mapper = new ObjectMapper()
    private def serializer = new XSSProtectionSerializer()
    private def serialize

    def setup() {
        def stringWriter = new StringWriter()
        def generator = mapper.getFactory().createGenerator(stringWriter)
        def provider = mapper.getSerializerProvider()
        serialize = { content ->
            serializer.serialize(content, generator, provider)
            generator.flush()
            stringWriter.toString()
        }
    }

    def 'XSSProtectionSerializer remove <script> tags'() {
        expect:
        '""' == serialize("<script>alert('1')</script>")
    }

    def 'XSSProtectionSerializer doesn\'t modify valid content'() {
        expect:
        '"BOSTON"' == serialize('BOSTON')
    }

    def 'XSSProtectionSerializer doesn\'t modify an empty string'() {
        expect:
        '""' == serialize('')
    }

    def 'XSSProtectionSerializer doesn\'t modify ampersands not part of an entity'() {
        expect:
        '"B&O"' == serialize('B&O')
    }
}
